/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;

public class CGRWindow
extends JFrame {
    public DNASequence seq;
    BufferedImage image_off;
    int[] color;
    public int[] count;
    public boolean invert;
    public boolean autoadjust;
    public int startIfs;
    public int lengthIfs;
    public int MEM;
    public int maximumIfs;
    public int MEMMASK;
    public float redIfs;
    public float blueIfs;
    public int prefixMask;
    public int x_prefix;
    public int y_prefix;
    public int linScale;
    public String prefixText;
    public String suffixText;
    public MainControl MainCtrl;
    public static ArrayList displayList;
    private JPanel UIcgr;
    private JLabel UIinfo;
    private JButton UIsaveImage;

    public CGRWindow() {
        this.initComponents();
        this.autoadjust = true;
        this.invert = false;
        this.seq = null;
        this.MainCtrl = null;
        displayList = null;
        this.color = new int[501];
        for (int x = 0; x < 501; ++x) {
            this.color[x] = this.getColor((float)x / 500.0f).getRGB();
        }
        this.redIfs = 5.0f;
        this.blueIfs = 0.0f;
        this.linScale = 0;
        this.prefixText = "";
        this.suffixText = "";
        this.setMem(8);
    }

    private void initComponents() {
        this.UIsaveImage = new JButton();
        this.UIcgr = new CGRView(this);
        this.UIinfo = new JLabel();
        this.setDefaultCloseOperation(2);
        this.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent evt) {
                CGRWindow.this.formWindowGainedFocus(evt);
            }

            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                CGRWindow.this.formWindowClosed(evt);
            }
        });
        this.UIsaveImage.setText("Save image");
        this.UIsaveImage.setHorizontalTextPosition(0);
        this.UIsaveImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CGRWindow.this.UIsaveImageActionPerformed(evt);
            }
        });
        this.UIcgr.setEnabled(false);
        this.UIcgr.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                CGRWindow.this.UIcgrMouseMoved(evt);
            }
        });
        this.UIcgr.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CGRWindow.this.UIcgrMouseClicked(evt);
            }
        });
        GroupLayout UIcgrLayout = new GroupLayout(this.UIcgr);
        this.UIcgr.setLayout(UIcgrLayout);
        UIcgrLayout.setHorizontalGroup(UIcgrLayout.createParallelGroup(1).add(0, 471, Short.MAX_VALUE));
        UIcgrLayout.setVerticalGroup(UIcgrLayout.createParallelGroup(1).add(0, 425, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(layout.createSequentialGroup().add(this.UIinfo, -1, 330, Short.MAX_VALUE).addPreferredGap(0).add(this.UIsaveImage, -2, 137, -2)).add(this.UIcgr, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(this.UIcgr, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add(layout.createParallelGroup(2, false).add(this.UIinfo, -1, -1, Short.MAX_VALUE).add(this.UIsaveImage, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.MainCtrl.CloseCGR(this);
    }

    public void updateTitle() {
        String title = this.seq.source.length() > 40 ? this.seq.source.substring(0, 40) : this.seq.source;
        title = title + String.format(" %d..%d", this.startIfs, this.startIfs + this.lengthIfs);
        this.setTitle(title);
    }

    private void UIcgrMouseClicked(MouseEvent evt) {
        JPanel p = (JPanel)evt.getSource();
        Insets i = p.getInsets();
        String s = "";
        int x = (int)((float)(this.MEMMASK + 1) * ((float)evt.getX() / (float)(p.getWidth() - 30)));
        int y = (int)((float)(this.MEMMASK + 1) * ((float)evt.getY() / (float)p.getHeight()));
        if (evt.getButton() == 1) {
            this.prefixText = this.prefixText + this.suffixText.substring(0, 1);
            s = this.suffixText.substring(0, 1);
            x = 2 * x;
            x &= this.MEMMASK;
            y = 2 * y;
            y &= this.MEMMASK;
        }
        if (evt.getButton() == 3) {
            if (this.prefixText.length() <= 0) {
                return;
            }
            s = this.prefixText.substring(this.prefixText.length() - 1, this.prefixText.length());
            this.prefixText = this.prefixText.substring(0, this.prefixText.length() - 1);
            x >>>= 1;
            y >>>= 1;
            if (s.charAt(0) == this.seq.layout.charAt(2)) {
                y |= this.MEMMASK + 1 >> 1;
            } else if (s.charAt(0) == this.seq.layout.charAt(3)) {
                x |= this.MEMMASK + 1 >> 1;
                y |= this.MEMMASK + 1 >> 1;
            } else if (s.charAt(0) == this.seq.layout.charAt(1)) {
                x |= this.MEMMASK + 1 >> 1;
            }
        }
        this.setPrefix(this.prefixText);
        if (s.charAt(0) == this.seq.layout.charAt(0)) {
            this.animateZoom(0, 0, evt);
        }
        if (s.charAt(0) == this.seq.layout.charAt(1)) {
            this.animateZoom(1, 0, evt);
        }
        if (s.charAt(0) == this.seq.layout.charAt(3)) {
            this.animateZoom(1, 1, evt);
        }
        if (s.charAt(0) == this.seq.layout.charAt(2)) {
            this.animateZoom(0, 1, evt);
        }
        this.MainCtrl.updateCgr(this);
        try {
            Point pt = p.getLocationOnScreen();
            int xs = pt.x + (int)((float)x / (float)(this.MEMMASK + 1) * (float)(p.getWidth() - 30));
            int ys = pt.y + (int)((float)y / (float)(this.MEMMASK + 1) * (float)p.getHeight());
            Robot robot = new Robot();
            robot.mouseMove(xs, ys);
        }
        catch (AWTException xc) {
            // empty catch block
        }
    }

    public void animateZoom(int xi, int yi, MouseEvent e) {
        BufferedImage imgtmp;
        int hd;
        int wd;
        int hs;
        int ws;
        int yd;
        int xd;
        int ys;
        int xs;
        JPanel p = (JPanel)e.getSource();
        Graphics g = p.getGraphics();
        int x = xi * (p.getWidth() - 30) / 2;
        int y = yi * p.getHeight() / 2;
        if (e.getButton() == 1) {
            xs = x;
            ys = y;
            xd = 0;
            yd = 0;
            ws = (p.getWidth() - 30) / 2;
            hs = p.getHeight() / 2;
            wd = p.getWidth() - 30;
            hd = p.getHeight();
            int tmp = (this.MEMMASK + 1) / 2;
            imgtmp = this.image_off.getSubimage(xi * tmp, yi * tmp, tmp, tmp);
        } else {
            xs = 0;
            ys = 0;
            xd = x;
            yd = y;
            wd = (p.getWidth() - 30) / 2;
            hd = p.getHeight() / 2;
            ws = p.getWidth() - 30;
            hs = p.getHeight();
            imgtmp = this.image_off;
        }
        int count = 20;
        double st = 1.0 / (double)count;
        g.setColor(Color.YELLOW);
        for (int i = 0; i <= count; ++i) {
            g.drawImage(imgtmp, (int)((double)xs + st * (double)(xd - xs) * (double)i), (int)((double)ys + st * (double)(yd - ys) * (double)i), (int)((double)ws + st * (double)(wd - ws) * (double)i), (int)((double)hs + st * (double)(hd - hs) * (double)i), this);
            g.drawRect((int)((double)xs + st * (double)(xd - xs) * (double)i), (int)((double)ys + st * (double)(yd - ys) * (double)i), (int)((double)ws + st * (double)(wd - ws) * (double)i), (int)((double)hs + st * (double)(hd - hs) * (double)i));
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void UIcgrMouseMoved(MouseEvent evt) {
        Insets in = this.UIcgr.getInsets();
        int x = (int)((float)(this.MEMMASK + 1) * ((float)evt.getX() / (float)(this.UIcgr.getWidth() - 30 - in.left - in.right)));
        int y = (int)((float)(this.MEMMASK + 1) * ((float)evt.getY() / (float)(this.UIcgr.getHeight() - in.top - in.bottom)));
        int x_cur = x;
        int y_cur = y;
        if (x <= this.MEMMASK && y <= this.MEMMASK) {
            String actual = "";
            String cnt = String.valueOf(this.count[(x & this.MEMMASK) << this.MEM | y & this.MEMMASK]);
            for (int j = 0; j < this.MEM; ++j) {
                if ((x & 1) == 1 && (y & 1) == 0) {
                    actual = this.seq.layout.charAt(1) + actual;
                }
                if ((x & 1) == 0 && (y & 1) == 1) {
                    actual = this.seq.layout.charAt(2) + actual;
                }
                if ((x & 1) == 0 && (y & 1) == 0) {
                    actual = this.seq.layout.charAt(0) + actual;
                }
                if ((x & 1) == 1 && (y & 1) == 1) {
                    actual = this.seq.layout.charAt(3) + actual;
                }
                x >>= 1;
                y >>= 1;
            }
            this.suffixText = actual;
            this.UIinfo.setText("Frequency of " + actual + " is " + cnt + ". Zoom prefix:" + this.prefixText);
        }
    }

    private void UIsaveImageActionPerformed(ActionEvent evt) {
        FileDialog fdlg = new FileDialog((Frame)this, "Save imato to *.png file", 1);
        fdlg.setFile("*.png");
        fdlg.setModal(true);
        fdlg.setVisible(true);
        if (fdlg.getFile() == null) {
            return;
        }
        String filename = fdlg.getDirectory() + fdlg.getFile();
        System.out.print(filename);
        File f = new File(filename);
        try {
            ImageIO.write((RenderedImage)this.image_off, "png", f);
        }
        catch (IOException er) {
            System.out.print(er.getMessage());
        }
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        if (this.MainCtrl != null) {
            this.MainCtrl.updateCgr(this);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new CGRWindow().setVisible(true);
            }
        });
    }

    public void assignSequence(DNASequence seq) {
        this.seq = seq;
        this.startIfs = 0;
        this.lengthIfs = seq.length / 10;
        this.recalculateIfs();
    }

    public void setMem(int depth) {
        this.MEM = depth;
        this.count = new int[(int)Math.pow(4.0, this.MEM)];
        this.MEMMASK = (int)Math.pow(2.0, this.MEM) - 1;
        this.image_off = new BufferedImage(this.MEMMASK + 1, this.MEMMASK + 1, 1);
        this.recalculateIfs();
    }

    public float recalculateIfs() {
        if (this.seq == null) {
            return 1.0f;
        }
        float curpos = 0.0f;
        for (int i = 0; i < this.count.length; ++i) {
            this.count[i] = 0;
        }
        boolean have = true;
        int ytmp = 0;
        int xtmp = 0;
        int y = 0;
        int x = 0;
        int endcycle = this.startIfs + this.lengthIfs;
        if (endcycle > this.seq.length - this.MEM + 1) {
            endcycle = this.seq.length - this.MEM + 1;
        }
        for (int i = this.startIfs; i < endcycle; ++i) {
            if (i % 32 == 0 && i + 32 <= this.seq.length) {
                xtmp = this.seq.x_data[1 + i / 32];
                ytmp = this.seq.y_data[1 + i / 32];
            }
            x |= (xtmp & 1) << 31;
            y |= (ytmp & 1) << 31;
            xtmp >>>= 1;
            ytmp >>>= 1;
            x >>>= 1;
            y >>>= 1;
            if (displayList != null) {
                have = false;
                for (int k = 0; k < displayList.size(); k += 2) {
                    if (i <= (Integer)displayList.get(k) || i >= (Integer)displayList.get(k + 1)) continue;
                    have = true;
                    break;
                }
            }
            if (have && (this.prefixMask & x >> this.MEM) == this.x_prefix && (this.prefixMask & y >> this.MEM) == this.y_prefix) {
                int n = (x & this.MEMMASK) << this.MEM | y & this.MEMMASK;
                this.count[n] = this.count[n] + 1;
            }
            if (!((curpos += 1000.0f / (float)(endcycle - this.startIfs)) > 1000.0f)) continue;
            curpos = 1000.0f;
        }
        this.maximumIfs = 0;
        for (x = 0; x < this.MEMMASK + 1; ++x) {
            for (y = 0; y < this.MEMMASK + 1; ++y) {
                if (this.maximumIfs >= this.count[(x & this.MEMMASK) << this.MEM | y & this.MEMMASK]) continue;
                this.maximumIfs = this.count[(x & this.MEMMASK) << this.MEM | y & this.MEMMASK];
            }
        }
        this.UIcgr.repaint();
        return this.maximumIfs;
    }

    protected Color getColor(float x) {
        x = 1.0f - x;
        float b = 0.0f;
        float g = 0.0f;
        float r = 0.0f;
        if (x >= 0.375f && x < 0.625f) {
            r = 4.0f * x - 1.5f;
        }
        if (x >= 0.625f && x < 0.875f) {
            r += 1.0f;
        }
        if (x >= 0.875f) {
            r += -4.0f * x + 4.5f;
        }
        if (x >= 0.125f && x < 0.375f) {
            g = 4.0f * x - 0.5f;
        }
        if (x >= 0.375f && x < 0.625f) {
            g += 1.0f;
        }
        if (x >= 0.625f && x < 0.875f) {
            g += -4.0f * x + 3.5f;
        }
        if (x < 0.125f) {
            b = 4.0f * x + 0.5f;
        }
        if (x >= 0.125f && x < 0.375f) {
            b += 1.0f;
        }
        if (x >= 0.375f && x < 0.625f) {
            b += -4.0f * x + 2.5f;
        }
        return new Color(b, g, r);
    }

    public void setColorInvert(Boolean b) {
        this.invert = b;
        this.repaint();
    }

    public void setAutoAdjust(Boolean b) {
        this.autoadjust = b;
        this.repaint();
    }

    public void redrawCGR(Graphics g) {
        int[] hist = new int[501];
        for (int x = 0; x < this.MEMMASK + 1; ++x) {
            for (int y = 0; y < this.MEMMASK + 1; ++y) {
                int c;
                if (this.count == null) continue;
                double c1 = this.count[(x & this.MEMMASK) << this.MEM | y & this.MEMMASK];
                if (this.linScale == 0) {
                    c1 = Math.log10(c1 + 1.0);
                    if (this.autoadjust) {
                        this.redIfs = (float)Math.log10(this.maximumIfs + 1);
                    }
                } else if (this.autoadjust) {
                    this.redIfs = this.maximumIfs;
                }
                if (this.redIfs == this.blueIfs) {
                    this.redIfs = 1.0f;
                }
                if ((c = (int)(500.0 * ((c1 - (double)this.blueIfs) / (double)this.redIfs))) > 500) {
                    c = 500;
                }
                if (c < 0) {
                    c = 0;
                }
                int n = c;
                hist[n] = hist[n] + 1;
                if (this.invert) {
                    c = 500 - c;
                }
                this.image_off.setRGB(x, y, this.color[c]);
            }
        }
        Dimension d = this.UIcgr.getSize();
        Insets i = this.UIcgr.getInsets();
        g.drawImage(this.image_off, 0, 0, d.width - 30, d.height, this);
        boolean total = false;
        int lastc = -1;
        for (int j = 0; j <= 500; ++j) {
            if (hist[j] > lastc) {
                lastc = hist[j];
            }
            if (j <= 0 || hist[j] != 0) continue;
            hist[j] = hist[j - 1];
        }
        for (int y = 0; y < d.height; ++y) {
            double max = this.redIfs;
            int c = (int)((double)(500.0f * ((float)(d.height - y) / (float)d.height - (float)((double)this.blueIfs / max))) / ((double)(this.redIfs - this.blueIfs) / max));
            if (c > 500) {
                c = 500;
            }
            if (c < 0) {
                c = 0;
            }
            int xi = 25 - (int)(25.0f * ((float)hist[c] / (float)lastc));
            if (this.invert) {
                c = 500 - c;
            }
            g.setColor(Color.decode(String.valueOf(this.color[c])));
            g.drawRect(d.width - 30, y, 30, 1);
            g.setColor(Color.LIGHT_GRAY);
            g.drawLine(d.width - xi, y, d.width, y);
        }
        g.setColor(Color.WHITE);
        double rad = Math.round(0.23 + Math.log10(this.redIfs));
        double step = Math.pow(10.0, rad - 1.0);
        FontMetrics fm = g.getFontMetrics();
        for (double y = 0.0; y <= (double)this.redIfs; y += step) {
            if (this.redIfs == 0.0f) continue;
            String txt = y != (double)Math.round(y) ? String.format("%2.1f", y) : String.format("%d", Math.round(y));
            Rectangle2D rct = fm.getStringBounds(txt, g);
            g.drawString(txt, d.width - 15 - (int)(rct.getWidth() / 2.0), (int)((double)d.height - y * (double)(d.height - 10) / (double)this.redIfs));
        }
        Font f = new Font("Verdana", 1, 20);
        g.setFont(f);
        g.drawString(this.seq.layout.substring(0, 1).toLowerCase(), 0, 20);
        g.drawString(this.seq.layout.substring(1, 2).toLowerCase(), d.width - 50, 20);
        g.drawString(this.seq.layout.substring(2, 3).toLowerCase(), 0, d.height);
        g.drawString(this.seq.layout.substring(3, 4).toLowerCase(), d.width - 50, d.height);
        this.updateTitle();
    }

    public void setPrefix(String prefix) {
        this.prefixText = prefix;
        this.prefixMask = 0;
        this.y_prefix = 0;
        this.x_prefix = 0;
        for (int i = 0; i < prefix.length(); ++i) {
            this.prefixMask <<= 1;
            this.prefixMask |= 1;
            this.x_prefix <<= 1;
            this.y_prefix <<= 1;
            if (prefix.charAt(i) == this.seq.layout.charAt(2)) {
                this.y_prefix |= 1;
                continue;
            }
            if (prefix.charAt(i) == this.seq.layout.charAt(3)) {
                this.x_prefix |= 1;
                this.y_prefix |= 1;
                continue;
            }
            if (prefix.charAt(i) != this.seq.layout.charAt(1)) continue;
            this.x_prefix |= 1;
        }
        this.recalculateIfs();
    }
}

