/*
 * Decompiled with CFR 0.152.
 */
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;

public class MainControl
extends JFrame {
    CGRWindow cgr;
    private int numCgr;
    private JCheckBox UIadjust;
    private JTextField UIblueIFS;
    private JList UIfeatures;
    private JTextArea UIinfo;
    private JCheckBox UIinvert;
    private JTextField UIlengthIFS;
    private JComboBox UImem;
    private JTextField UIredIFS;
    private JComboBox UIscale;
    private JButton UIsetFeatureRegion;
    private JTextField UIstartIfs;
    private JSlider UIstartIfsSlider;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;

    public MainControl() {
        this.initComponents();
        this.cgr = null;
        this.numCgr = 0;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.UIstartIfs = new JTextField();
        this.UIstartIfsSlider = new JDNASlider(this);
        this.jLabel3 = new JLabel();
        this.UIlengthIFS = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.UImem = new JComboBox();
        this.jLabel4 = new JLabel();
        this.UIblueIFS = new JTextField();
        this.UIredIFS = new JTextField();
        this.UIscale = new JComboBox();
        this.UIinvert = new JCheckBox();
        this.UIadjust = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.UIinfo = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.UIfeatures = new JList();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.UIsetFeatureRegion = new JButton();
        this.setDefaultCloseOperation(3);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Region"));
        this.jPanel1.setToolTipText("Select start and length of region to visualize");
        this.jLabel2.setText("Start");
        this.UIstartIfs.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                MainControl.this.UIstartIfsKeyReleased(evt);
            }
        });
        this.UIstartIfsSlider.setMajorTickSpacing(250);
        this.UIstartIfsSlider.setMaximum(1000);
        this.UIstartIfsSlider.setMinorTickSpacing(250);
        this.UIstartIfsSlider.setPaintLabels(true);
        this.UIstartIfsSlider.setPaintTicks(true);
        this.UIstartIfsSlider.setPaintTrack(false);
        this.UIstartIfsSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MainControl.this.UIstartIfsSliderStateChanged(evt);
            }
        });
        this.jLabel3.setText("Length");
        this.UIlengthIFS.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                MainControl.this.UIlengthIFSKeyReleased(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(this.UIstartIfsSlider, -1, 454, Short.MAX_VALUE).add(jPanel1Layout.createSequentialGroup().add(this.jLabel2).add(13, 13, 13).add(this.UIstartIfs, -2, 85, -2).addPreferredGap(0).add(this.jLabel3).addPreferredGap(0).add(this.UIlengthIFS, -2, 96, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.UIstartIfsSlider, -2, -1, -2).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createParallelGroup(3).add(this.UIstartIfs, -2, -1, -2).add(this.jLabel2).add(this.jLabel3)).add(this.UIlengthIFS, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.getAccessibleContext().setAccessibleName("Visualisation range");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Visualisation settings"));
        this.jLabel1.setText("Oligomer length");
        this.UImem.setModel(new DefaultComboBoxModel<String>(new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10"}));
        this.UImem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainControl.this.UImemActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Colour range");
        this.UIblueIFS.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                MainControl.this.UIblueIFSKeyReleased(evt);
            }
        });
        this.UIredIFS.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                MainControl.this.UIredIFSKeyReleased(evt);
            }
        });
        this.UIscale.setModel(new DefaultComboBoxModel<String>(new String[]{"log(count+1)", "linear"}));
        this.UIscale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainControl.this.UIscaleActionPerformed(evt);
            }
        });
        this.UIinvert.setText("Invert");
        this.UIinvert.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.UIinvert.setMargin(new Insets(0, 0, 0, 0));
        this.UIinvert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainControl.this.UIinvertActionPerformed(evt);
            }
        });
        this.UIadjust.setSelected(true);
        this.UIadjust.setText("Auto adjust");
        this.UIadjust.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.UIadjust.setMargin(new Insets(0, 0, 0, 0));
        this.UIadjust.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainControl.this.UIadjustActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(this.jLabel4).add(17, 17, 17).add(this.UIblueIFS, -2, 65, -2).addPreferredGap(0).add(this.UIredIFS, -2, 68, -2).addPreferredGap(0).add(this.UIscale, -2, -1, -2).add(6, 6, 6).add(this.UIinvert).add(6, 6, 6).add(this.UIadjust)).add(jPanel2Layout.createSequentialGroup().addPreferredGap(0).add(this.jLabel1).addPreferredGap(0).add(this.UImem, -2, -1, -2))).addContainerGap(19, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(3).add(this.jLabel4).add(this.UIscale, -2, 22, -2).add(this.UIinvert).add(this.UIblueIFS, -2, -1, -2).add(this.UIredIFS, -2, -1, -2).add(this.UIadjust, -2, 15, -2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel1).add(this.UImem, -2, -1, -2))));
        this.jPanel2.getAccessibleContext().setAccessibleName("Visualisation settings");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Features"));
        this.UIinfo.setColumns(20);
        this.UIinfo.setRows(5);
        this.jScrollPane2.setViewportView(this.UIinfo);
        this.UIfeatures.setSelectionMode(0);
        this.UIfeatures.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                MainControl.this.UIfeaturesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.UIfeatures);
        this.jLabel5.setText("Name");
        this.jLabel6.setText("Description");
        this.UIsetFeatureRegion.setText("Visualise");
        this.UIsetFeatureRegion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainControl.this.UIsetFeatureRegionActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().addContainerGap().add(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(jPanel3Layout.createParallelGroup(1).add(this.jLabel5).add(this.jScrollPane1, -2, 184, -2)).addPreferredGap(0).add(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(this.jLabel6).addPreferredGap(0, 211, Short.MAX_VALUE)).add(this.jScrollPane2, -1, 264, Short.MAX_VALUE))).add(this.UIsetFeatureRegion)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(jPanel3Layout.createParallelGroup(3).add(this.jLabel5).add(this.jLabel6)).add(8, 8, 8).add(jPanel3Layout.createParallelGroup(1).add(this.jScrollPane1, -1, 151, Short.MAX_VALUE).add(this.jScrollPane2, -1, 151, Short.MAX_VALUE)).addPreferredGap(0).add(this.UIsetFeatureRegion).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jPanel2, -1, -1, Short.MAX_VALUE).add(this.jPanel1, -1, -1, Short.MAX_VALUE).add(this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel2, -2, -1, -2).addPreferredGap(0).add(this.jPanel3, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void UIadjustActionPerformed(ActionEvent evt) {
        if (this.cgr == null) {
            return;
        }
        this.cgr.setAutoAdjust(this.UIadjust.isSelected());
    }

    private void UIinvertActionPerformed(ActionEvent evt) {
        if (this.cgr == null) {
            return;
        }
        this.cgr.setColorInvert(this.UIinvert.isSelected());
    }

    private void UIsetFeatureRegionActionPerformed(ActionEvent evt) {
        int i = this.UIfeatures.getSelectedIndex();
        if (i >= 0) {
            CGRWindow.displayList = (ArrayList)this.cgr.seq.seqList.get(i);
            if (i < this.cgr.seq.infoList.size()) {
                this.UIinfo.setText((String)this.cgr.seq.infoList.get(i));
                this.UIinfo.setCaretPosition(0);
            }
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            int k = 0;
            while (true) {
                if (k >= CGRWindow.displayList.size()) break;
                if (min > (Integer)CGRWindow.displayList.get(k)) {
                    min = (Integer)CGRWindow.displayList.get(k);
                }
                if (max < (Integer)CGRWindow.displayList.get(k)) {
                    max = (Integer)CGRWindow.displayList.get(k);
                }
                ++k;
            }
            if (max == Integer.MAX_VALUE) {
                return;
            }
            if (max < min) {
                return;
            }
            this.cgr.startIfs = min;
            this.cgr.lengthIfs = max - min;
            int pos = (int)((float)this.cgr.startIfs * (1000.0f / (float)this.cgr.seq.length));
            this.UIstartIfsSlider.setValue(pos);
            this.cgr.recalculateIfs();
            this.UIstartIfsSlider.repaint();
            this.UIstartIfs.setText(String.valueOf(this.cgr.startIfs));
            this.UIlengthIFS.setText(String.valueOf(this.cgr.lengthIfs));
        } else {
            CGRWindow.displayList = null;
        }
    }

    private void UIscaleActionPerformed(ActionEvent evt) {
        int i;
        if (this.cgr == null) {
            return;
        }
        this.cgr.linScale = i = this.UIscale.getSelectedIndex();
        this.cgr.repaint();
    }

    private void UIfeaturesValueChanged(ListSelectionEvent evt) {
        if (this.cgr == null) {
            return;
        }
        int i = this.UIfeatures.getSelectedIndex();
        JDNASliderUI s = (JDNASliderUI)this.UIstartIfsSlider.getUI();
        if (i >= 0) {
            CGRWindow.displayList = (ArrayList)this.cgr.seq.seqList.get(i);
            if (i < this.cgr.seq.infoList.size()) {
                this.UIinfo.setText((String)this.cgr.seq.infoList.get(i));
                this.UIinfo.setCaretPosition(0);
            }
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            int k = 0;
            while (true) {
                if (k >= CGRWindow.displayList.size()) break;
                if (min > (Integer)CGRWindow.displayList.get(k)) {
                    min = (Integer)CGRWindow.displayList.get(k);
                }
                if (max < (Integer)CGRWindow.displayList.get(k)) {
                    max = (Integer)CGRWindow.displayList.get(k);
                }
                ++k;
            }
            s.Fstart = min;
            s.Flen = max - min;
            this.UIstartIfsSlider.repaint();
        } else {
            CGRWindow.displayList = null;
            s.Flen = 0;
            s.Fstart = 0;
        }
    }

    private void UIredIFSKeyReleased(KeyEvent evt) {
        if (this.cgr == null) {
            return;
        }
        try {
            float tmp = Float.parseFloat(this.UIredIFS.getText());
            if (tmp > this.cgr.blueIfs) {
                this.cgr.redIfs = tmp;
            }
            if (!this.cgr.autoadjust) {
                this.cgr.repaint();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void UIblueIFSKeyReleased(KeyEvent evt) {
        if (this.cgr == null) {
            return;
        }
        try {
            float tmp;
            this.cgr.blueIfs = tmp = Float.parseFloat(this.UIblueIFS.getText());
            this.cgr.repaint();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void UImemActionPerformed(ActionEvent evt) {
        if (this.cgr == null) {
            return;
        }
        int value = this.UImem.getSelectedIndex();
        if (value > 0) {
            this.cgr.setMem(value + 2);
        }
    }

    private void UIlengthIFSKeyReleased(KeyEvent evt) {
        if (this.cgr == null) {
            return;
        }
        try {
            int value = Integer.parseInt(this.UIlengthIFS.getText());
            if (value > 0) {
                this.cgr.lengthIfs = value;
            }
            this.cgr.recalculateIfs();
            this.UIstartIfsSlider.repaint();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void UIstartIfsKeyReleased(KeyEvent evt) {
        if (this.cgr == null) {
            return;
        }
        try {
            int value = Integer.parseInt(this.UIstartIfs.getText());
            if (value > 0) {
                this.cgr.startIfs = value;
            }
            int pos = (int)((float)this.cgr.startIfs * (1000.0f / (float)this.cgr.seq.length));
            this.UIstartIfsSlider.setValue(pos);
            this.cgr.recalculateIfs();
            this.UIstartIfsSlider.repaint();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void UIstartIfsSliderStateChanged(ChangeEvent evt) {
        if (!this.UIstartIfsSlider.getValueIsAdjusting()) {
            return;
        }
        if (this.cgr == null) {
            return;
        }
        int pos = this.UIstartIfsSlider.getValue();
        this.cgr.startIfs = (int)((float)pos / 1000.0f * (float)this.cgr.seq.length);
        if (this.cgr.startIfs < 0) {
            this.cgr.startIfs = 0;
        }
        if (this.cgr.startIfs > this.cgr.seq.length) {
            this.cgr.startIfs = this.cgr.seq.length;
        }
        this.UIstartIfs.setText(String.valueOf(this.cgr.startIfs));
        this.UIlengthIFS.setText(String.valueOf(this.cgr.lengthIfs));
        float maximum = this.cgr.recalculateIfs();
        if (this.cgr.linScale == 1) {
            this.UIredIFS.setText(String.format("%g", Float.valueOf(maximum)));
        } else {
            this.UIredIFS.setText(String.format("%g", Math.log10(maximum + 1.0f)));
        }
        this.UIstartIfsSlider.repaint();
        CGRWindow.displayList = null;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainControl().setVisible(true);
            }
        });
    }

    public void updateCgr(CGRWindow c) {
        int step = 250;
        this.cgr = c;
        this.setTitle("Visualisation control window: " + this.cgr.getTitle());
        this.UIstartIfs.setText(String.valueOf(this.cgr.startIfs));
        this.UIlengthIFS.setText(String.valueOf(this.cgr.lengthIfs));
        int pos = (int)((float)this.cgr.startIfs * (1000.0f / (float)this.cgr.seq.length));
        this.UIstartIfsSlider.setValue(pos);
        this.UIstartIfsSlider.setMajorTickSpacing(250);
        this.UIstartIfsSlider.setMinorTickSpacing(25);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("0"));
        labelTable.put(new Integer(1000), new JLabel(String.format("%.2f Mbp", Float.valueOf((float)this.cgr.seq.length / 1000000.0f))));
        for (int i = 250; i < 1000; i += 250) {
            labelTable.put(new Integer(i), new JLabel(String.format("%.2f", Float.valueOf((float)i / 1000.0f * (float)this.cgr.seq.length / 1000000.0f))));
        }
        this.UIstartIfsSlider.setLabelTable(labelTable);
        this.UImem.setSelectedIndex(c.MEM - 2);
        this.UIblueIFS.setText(String.valueOf(c.blueIfs));
        this.UIredIFS.setText(String.valueOf(c.redIfs));
        this.UIfeatures.setListData(c.seq.featureList);
        this.UIinfo.setText("");
    }

    public void CloseCGR(CGRWindow c) {
        --this.numCgr;
        if (this.cgr == c) {
            this.cgr = null;
        }
        if (this.numCgr == 0) {
            this.setVisible(false);
        }
    }

    public void addCGRwindow(CGRWindow c) {
        ++this.numCgr;
        c.setTitle("Window " + this.numCgr + ": " + c.seq.source);
        this.setVisible(true);
    }
}

