/*
 * Decompiled with CFR 0.152.
 */
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;

public class MainPanel
extends JFrame {
    private Vector UIsequenceListData;
    private Vector UIsequenceListText;
    private Vector CGRWindows;
    public static MainControl MainCtrl;
    public int progressValue;
    public String layout;
    static int nextProgress;
    private JButton UIaddSequence;
    private JButton UIdeleteSequence;
    private JTextArea UIheader;
    private JList UIsequenceList;
    private JButton UIvisualise;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;

    public MainPanel() {
        this.initComponents();
        this.UIsequenceListText = new Vector();
        this.UIsequenceListData = new Vector();
        this.CGRWindows = new Vector();
        this.progressValue = 0;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.UIsequenceList = new JList();
        this.UIaddSequence = new JButton();
        this.UIvisualise = new JButton();
        this.UIdeleteSequence = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.UIheader = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        this.setDefaultCloseOperation(3);
        this.UIsequenceList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                MainPanel.this.UIsequenceListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.UIsequenceList);
        this.UIaddSequence.setText("Add");
        this.UIaddSequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.UIaddSequenceActionPerformed(evt);
            }
        });
        this.UIvisualise.setText("Open visualisation");
        this.UIvisualise.setEnabled(false);
        this.UIvisualise.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.UIvisualiseActionPerformed(evt);
            }
        });
        this.UIdeleteSequence.setText("Delete");
        this.UIdeleteSequence.setEnabled(false);
        this.UIdeleteSequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.UIdeleteSequenceActionPerformed(evt);
            }
        });
        this.UIheader.setColumns(20);
        this.UIheader.setLineWrap(true);
        this.UIheader.setRows(5);
        this.jScrollPane2.setViewportView(this.UIheader);
        this.jLabel1.setText("Details");
        this.jLabel2.setText("Name");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(2).add(1, this.jScrollPane2, -1, 496, Short.MAX_VALUE).add(1, jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(2, false).add(1, this.jScrollPane1, -1, 367, Short.MAX_VALUE).add(1, this.jLabel2)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(this.UIdeleteSequence, -1, 123, Short.MAX_VALUE).add(this.UIaddSequence, 0, 0, Short.MAX_VALUE).add(this.UIvisualise))).add(1, this.jLabel1)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.jLabel2).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1, false).add(jPanel1Layout.createSequentialGroup().add(this.UIaddSequence).addPreferredGap(0).add(this.UIdeleteSequence).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.UIvisualise, -2, 23, -2)).add(2, this.jScrollPane1, -2, 92, -2)).addPreferredGap(0).add(this.jLabel1).addPreferredGap(0).add(this.jScrollPane2, -1, 204, Short.MAX_VALUE).addContainerGap()));
        this.getContentPane().add(this.jPanel1);
        this.pack();
    }

    private void UIsequenceListValueChanged(ListSelectionEvent evt) {
        int i = this.UIsequenceList.getSelectedIndex();
        if (i >= 0) {
            this.UIvisualise.setEnabled(true);
            this.UIdeleteSequence.setEnabled(true);
            DNASequence seq = (DNASequence)this.UIsequenceListData.get(i);
            this.UIheader.setText(seq.header);
            this.UIheader.setCaretPosition(0);
        } else {
            this.UIvisualise.setEnabled(false);
            this.UIdeleteSequence.setEnabled(false);
            this.UIheader.setText("");
        }
    }

    private void UIdeleteSequenceActionPerformed(ActionEvent evt) {
        int i = this.UIsequenceList.getSelectedIndex();
        if (i >= 0) {
            Iterator it = this.CGRWindows.iterator();
            while (it.hasNext()) {
                CGRWindow act = (CGRWindow)it.next();
                if (act.seq != this.UIsequenceListData.get(i)) continue;
                act.dispose();
                it.remove();
            }
            this.UIsequenceListData.remove(i);
            this.UIsequenceListText.remove(i);
            this.UIsequenceList.setListData(this.UIsequenceListText);
        }
    }

    private void UIvisualiseActionPerformed(ActionEvent evt) {
        int i = this.UIsequenceList.getSelectedIndex();
        if (i >= 0) {
            CGRWindow w = new CGRWindow();
            w.MainCtrl = MainCtrl;
            w.setVisible(true);
            w.assignSequence((DNASequence)this.UIsequenceListData.get(i));
            MainCtrl.setVisible(true);
            MainCtrl.addCGRwindow(w);
            this.CGRWindows.add(w);
        }
    }

    public void UIaddPartialSequence(DNASequence seq) {
        this.UIsequenceListText.addElement(seq.source);
        this.UIsequenceListData.addElement(seq);
        this.UIsequenceList.setListData(this.UIsequenceListText);
    }

    private void UIaddSequenceActionPerformed(ActionEvent evt) {
        FileDialog fdlg = new FileDialog((Frame)this, "Browse for GeneBank of Fasta file");
        fdlg.setFile("*.*");
        fdlg.setModal(true);
        fdlg.setVisible(true);
        if (fdlg.getFile() == null) {
            return;
        }
        String filename = fdlg.getDirectory() + fdlg.getFile();
        DNASequence seq = new DNASequence();
        seq.layout = this.layout;
        if (seq.loadFile(filename, this)) {
            this.UIaddPartialSequence(seq);
        }
    }

    public void addProgress(int step) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MainPanel m = new MainPanel();
                FirstSetup f = new FirstSetup(m, true);
                if (f.answer == null || f.answer.length() != 4) {
                    return;
                }
                m.layout = f.answer;
                m.setLocationByPlatform(true);
                m.setVisible(true);
                m.setTitle("Main application window");
                MainCtrl = new MainControl();
                MainCtrl.setTitle("Visualisation control window");
                MainCtrl.setLocation(m.getLocation().x, m.getLocation().y + m.getHeight());
            }
        });
    }

    static {
        nextProgress = 0;
    }
}

