/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DNASequence {
    public String layout;
    public String source;
    public String header = "";
    public int length = 0;
    public int[] x_data;
    public int[] y_data;
    private int i;
    private int x;
    private int y;
    private int f;
    public ArrayList seqList = new ArrayList();
    public ArrayList infoList = new ArrayList();
    public Vector featureList = new Vector();

    public boolean loadFile(String filename, MainPanel panel) {
        if (filename.endsWith(".gb") || filename.endsWith(".gbs") || filename.endsWith(".gbk")) {
            return this.loadGB(filename, panel);
        }
        if (filename.endsWith(".fasta")) {
            return this.loadFasta(filename, panel);
        }
        return false;
    }

    public void startData() {
        this.x_data = new int[this.length / 32 + 1];
        this.y_data = new int[this.length / 32 + 1];
        this.i = 0;
        this.f = 0;
        this.y = 0;
        this.x = 0;
    }

    public void finalizeData() {
        this.length = this.i;
    }

    public void addData(String line) {
        line = line.toUpperCase();
        byte[] buf1 = line.getBytes();
        for (int j = 0; j < buf1.length; ++j) {
            if (buf1[j] != 65 && buf1[j] != 67 && buf1[j] != 71 && buf1[j] != 84) continue;
            byte c = buf1[j];
            if (this.i > 0 && this.i % 32 == 0) {
                this.x_data[this.i / 32 - 1] = this.x;
                this.y_data[this.i / 32 - 1] = this.y;
                this.y = 0;
                this.x = 0;
            }
            this.x >>>= 1;
            this.y >>>= 1;
            if (c == this.layout.charAt(2)) {
                this.y |= Integer.MIN_VALUE;
            } else if (c == this.layout.charAt(3)) {
                this.x |= Integer.MIN_VALUE;
                this.y |= Integer.MIN_VALUE;
            } else if (c == this.layout.charAt(1)) {
                this.x |= Integer.MIN_VALUE;
            } else if (c != this.layout.charAt(0)) continue;
            ++this.i;
        }
    }

    public DNASequence clone() {
        DNASequence ret = new DNASequence();
        ret.source = this.source;
        ret.length = this.length;
        ret.x_data = (int[])this.x_data.clone();
        ret.y_data = (int[])this.y_data.clone();
        ret.header = this.header;
        ret.featureList = this.featureList;
        ret.seqList = this.seqList;
        ret.infoList = this.infoList;
        return ret;
    }

    public boolean loadFasta(String filename, MainPanel panel) {
        this.length = (int)new File(filename).length();
        this.source = filename;
        byte[] buf = new byte[this.length];
        try {
            FileInputStream fis = new FileInputStream(filename);
            BufferedReader in = new BufferedReader(new InputStreamReader(fis));
            String aLine = null;
            this.startData();
            int state = -2;
            while ((aLine = in.readLine()) != null && state != -1) {
                if (state == -2) {
                    if (aLine.startsWith(">")) {
                        this.source = aLine;
                        this.header = aLine;
                        state = 2;
                        continue;
                    }
                    return false;
                }
                if (aLine.startsWith(">")) {
                    state = -1;
                    continue;
                }
                if (state != 2) continue;
                this.addData(aLine);
            }
            this.finalizeData();
            in.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return true;
    }

    public int getGBsize(String filename) {
        int size = 0;
        try {
            FileInputStream fis = new FileInputStream(filename);
            BufferedReader in = new BufferedReader(new InputStreamReader(fis));
            int state = -2;
            String aLine = null;
            while ((aLine = in.readLine()) != null && state != -1) {
                if (aLine.startsWith("ORIGIN")) {
                    state = 1;
                    continue;
                }
                if (aLine.startsWith("//")) {
                    state = -1;
                    continue;
                }
                size += aLine.length();
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return size;
    }

    public boolean loadGB(String filename, MainPanel panel) {
        this.length = this.getGBsize(filename);
        this.source = filename;
        byte[] buf = new byte[this.length];
        try {
            FileInputStream fis = new FileInputStream(filename);
            BufferedReader in = new BufferedReader(new InputStreamReader(fis));
            Pattern p = Pattern.compile("^     \\w+");
            Matcher m = p.matcher("");
            String aLine = null;
            String Features = "";
            this.startData();
            int state = -2;
            while ((aLine = in.readLine()) != null && state != -1) {
                if (state == -2) {
                    if (aLine.startsWith("LOCUS")) {
                        this.source = aLine.substring(12, aLine.indexOf(32, 12));
                        state = 0;
                    } else {
                        return false;
                    }
                }
                if (aLine.startsWith("//")) {
                    state = -1;
                } else if (!aLine.startsWith("LOCUS")) {
                    if (aLine.startsWith("FEATURES")) {
                        state = 1;
                    } else if (aLine.startsWith("ORIGIN")) {
                        state = 2;
                        Features = null;
                    } else if (state == 1) {
                        m.reset(aLine);
                        if (!m.find()) {
                            Features = Features + aLine + "\n";
                        } else {
                            if (Features != "") {
                                Integer min = Integer.MAX_VALUE;
                                Integer max = Integer.MIN_VALUE;
                                Pattern p1 = Pattern.compile("\\d+\\.\\.\\d+");
                                Matcher m1 = p1.matcher(Features);
                                ArrayList<Integer> tmp1 = new ArrayList<Integer>();
                                tmp1.add(min);
                                tmp1.add(max);
                                while (m1.find()) {
                                    Pattern p2 = Pattern.compile("\\d+");
                                    Matcher m2 = p2.matcher(m1.group());
                                    if (!m2.find()) continue;
                                    Integer start = Integer.parseInt(m2.group());
                                    if (!m2.find()) continue;
                                    Integer stop = Integer.parseInt(m2.group());
                                    if (min > start) {
                                        min = start;
                                    }
                                    if (max >= stop) continue;
                                    max = stop;
                                }
                                tmp1.set(0, min);
                                tmp1.set(1, max);
                                this.seqList.add(tmp1);
                                String name = Features.substring(0, Features.indexOf(32, 6));
                                Pattern p2 = Pattern.compile("/gene=\"(\\w+)\"");
                                Matcher m2 = p2.matcher(Features);
                                name = name.trim();
                                if (m2.find()) {
                                    name = name + " - " + m2.group(1);
                                }
                                this.infoList.add(Features);
                                this.featureList.add(name);
                            }
                            Features = aLine + "\n";
                        }
                    } else if (state == 2) {
                        this.addData(aLine);
                    }
                }
                if (state != 0) continue;
                this.header = this.header + aLine + "\n";
            }
            this.finalizeData();
            in.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return true;
    }
}

